#include <DHT.h>
#include <MOVIShield.h>

#define DHT_PIN 3
#define DHT_TYPE DHT11

DHT dht(DHT_PIN, DHT_TYPE);
MOVI movi(false);

char answer[21];

void setup() {
  // tutaj powinien się znaleźć kod inicjalizacji, który uruchamiamy tylko raz:
  dht.begin();
  movi.init();
  movi.callSign("buddy"); 
  movi.addSentence("temp"); 
  movi.init();  
}

void loop() {
  // tutaj powinien się znaleźć główny kod, który uruchamia się wielokrotnie: 
  signed int res=movi.poll();
  if (res == 1) {
    float fahreheit = dht.readTemperature(true);
    int tmp = (int)fahreheit;
    sprintf(answer, "Temperatura wynosi %02d", tmp);
    movi.say(answer);
  }
}
